#include <stdio.h>
#include <stdlib.h>
#include <cilk/cilk.h>
#include <cilk/cilk_api.h>
#include <cilk/cilkscale.h>

int result;
int n;

void prepare() {
        printf("Fibonacci index : %d \n",n);
}

int fib(int n) {
  if (n < 2)
    return n;
  int x = cilk_spawn fib(n-1);
  int y = fib(n-2); /* this a best practice that on recursions, like here do not spawn all the recursion instances, here we just spawn x and keeping y as it is. You can try spawn both and see the scalability report*/
  cilk_sync; /* each spawn should be followed by cilk_sync; otherwise compiler will complain about it, we put it after compute() invocation in the main (see below) */
  return x + y;
}

void compute(){
        result = fib(n);
}

void report(){

        printf("Fibonacci result is %d\n",result);
        }

int main(int argc, char *argv[]) {
        n = atoi(argv[1]);
        prepare(); /* preparation stuff like declarations, memory allocations if any and etc. and this part should be kept outside ROI */

        wsp_t start, end; /* declaration of opencilk scalability probes. */
        start = wsp_getworkspan(); /* starting point to record the scalability data */

        compute(); /*usually this is most expensive computational part, and we call it ROI (region of Interest) to evaluate the core computational part of the experiment*/

        end = wsp_getworkspan();
        wsp_dump(wsp_sub(end, start), "fib scalability report"); /* this is the optional naming to your plot of the scalability report */

        report(); /* to report output of the experiment on stdout outside ROI */
        return 0;
}
