#include <cilk/cilk.h>
#include <iostream>
#include <vector>

int main() {
    std::vector<int> A(1000);
    for (int i = 0; i < 1000; ++i) A[i] = i;

    int sum = 0;  // shared variable — will be raced on!

    cilk_for (int i = 0; i < 1000; ++i) {
        sum += A[i];   // DATA RACE: unsynchronized write/read on 'sum'
    }

    std::cout << "Result=" << sum << "\n";
    return 0;
}
