#include <cilk/cilk.h>
#include <iostream>
#include <vector>

// Reducer callbacks for int summation
void int_zero(void *view)  { *(int*)view = 0; }
void int_add(void *left, void *right) {
    *(int*)left += *(int*)right;
}

int main() {
    std::vector<int> A(1000);
    for (int i = 0; i < 1000; ++i) A[i] = i;

    // Declare a reducer of type int
    int cilk_reducer(int_zero, int_add) result = 0;

    cilk_for (int i = 0; i < 1000; ++i) {
        result += A[i];
    }

    int sum = result;  // extract the final value
    std::cout << "Result=" << sum << "\n";
    return 0;
}
